// Generated by CoffeeScript 1.12.7
(function() {
  var Adapter, PostCSS, W, convert, path, sourcemaps,
    extend = function(child, parent) { for (var key in parent) { if (hasProp.call(parent, key)) child[key] = parent[key]; } function ctor() { this.constructor = child; } ctor.prototype = parent.prototype; child.prototype = new ctor(); child.__super__ = parent.prototype; return child; },
    hasProp = {}.hasOwnProperty;

  Adapter = require('../../adapter_base');

  sourcemaps = require('../../sourcemaps');

  W = require('when');

  path = require('path');

  convert = require('convert-source-map');

  PostCSS = (function(superClass) {
    extend(PostCSS, superClass);

    function PostCSS() {
      return PostCSS.__super__.constructor.apply(this, arguments);
    }

    PostCSS.prototype.name = 'postcss';

    PostCSS.prototype.extensions = ['css', 'pcss', 'sss'];

    PostCSS.prototype.output = 'css';

    PostCSS.prototype._render = function(str, options) {
      var processor, ref, use;
      use = (ref = options.use) != null ? ref : [];
      processor = this.engine(use);
      if (options.map === true) {
        options.map = {
          inline: false
        };
        options.from = options.filename;
      }
      return W(processor.process(str, options)).then(function(res) {
        var obj;
        obj = {
          result: res.css
        };
        if (options.map) {
          obj.sourcemap = JSON.parse(res.map);
          obj.result = convert.removeMapFileComments(obj.result).trim();
          return sourcemaps.inline_sources(obj.sourcemap).then(function(map) {
            obj.sourcemap = map;
            return obj;
          });
        } else {
          return obj;
        }
      });
    };

    return PostCSS;

  })(Adapter);

  module.exports = PostCSS;

}).call(this);
